package ContoCorrente.java;

class ContoSpeciale extends ContoCorrente{
	private final double LIMITE = 200.0;
	// overriding: metodo sovrascritto
	public void preleva(double importo)  { 
		// verifica il limite di prelievo
		if (importo <= LIMITE)    {
			// verifica la disponibilita' del saldo
			if (importo <= getSaldo()) {
				super.preleva(importo);
			}
			else {
				System.out.println("Prelievo non disponibile.");
			}
		}
		else {
			System.out.println("Prelievo rifiutato.");
		}
	}
	  // overloading: metodo sovraccaricato
	public void versa(Assegno assegno)  {super.versa(assegno.importo);  }
}